/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.json;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeApplier;
import com.ferreusveritas.dynamictrees.worldgen.json.JsonMath;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.world.biome.Biome;

public class JsonBiomePropertyApplierChance
implements IJsonBiomeApplier {
    @Override
    public void apply(BiomeDataBase dbase, JsonElement element, Biome biome) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            dbase.setChanceSelector(biome, this.readChanceSelector(object, biome), this.readMethod(object));
        } else if (element.isJsonPrimitive()) {
            String simple;
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isNumber()) {
                dbase.setChanceSelector(biome, this.createSimpleChanceSelector(prim.getAsFloat()), BiomeDataBase.Operation.REPLACE);
            } else if (prim.isString() && "standard".equals(simple = prim.getAsString())) {
                dbase.setChanceSelector(biome, (rnd, spc, rad) -> rnd.nextFloat() < (rad > 3 ? 2.0f / (float)rad : 1.0f) ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
            }
        }
    }

    private BiomePropertySelectors.IChanceSelector createSimpleChanceSelector(float value) {
        if (value <= 0.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL;
        }
        if (value >= 1.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK;
        }
        return (rnd, spc, rad) -> rnd.nextFloat() < value ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
    }

    private BiomePropertySelectors.IChanceSelector readChanceSelector(JsonObject mainObject, Biome biome) {
        JsonElement mathElement;
        JsonElement staticElement = mainObject.get("static");
        if (staticElement != null && staticElement.isJsonPrimitive()) {
            String value;
            if (staticElement.getAsJsonPrimitive().isNumber()) {
                return this.createSimpleChanceSelector(staticElement.getAsJsonPrimitive().getAsFloat());
            }
            if (staticElement.getAsJsonPrimitive().isString() && this.isDefault(value = staticElement.getAsString())) {
                return (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.UNHANDLED;
            }
        }
        if ((mathElement = mainObject.get("math")) != null) {
            JsonMath m = new JsonMath(mathElement, biome);
            return (rnd, spc, rad) -> rnd.nextFloat() < m.apply(rnd, spc, rad) ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
        }
        return null;
    }
}

